/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network;

import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.network.LunarContextConstructionPacket;
import corgitaco.enhancedcelestials.network.LunarEventChangedPacket;
import corgitaco.enhancedcelestials.network.LunarForecastChangedPacket;
import corgitaco.enhancedcelestials.network.S2CPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("enhancedcelestials", "network"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        EnhancedCelestials.LOGGER.debug(String.format("Initializing %s network...", "enhancedcelestials"));
        SIMPLE_CHANNEL.registerMessage(0, LunarContextConstructionPacket.class, LunarContextConstructionPacket::write, LunarContextConstructionPacket::readFromPacket, ForgeNetworkHandler::handle);
        SIMPLE_CHANNEL.registerMessage(1, LunarEventChangedPacket.class, LunarEventChangedPacket::write, LunarEventChangedPacket::readFromPacket, ForgeNetworkHandler::handle);
        SIMPLE_CHANNEL.registerMessage(2, LunarForecastChangedPacket.class, LunarForecastChangedPacket::write, LunarForecastChangedPacket::readFromPacket, ForgeNetworkHandler::handle);
        EnhancedCelestials.LOGGER.info(String.format("Initialized %s network!", "enhancedcelestials"));
    }

    public static <T extends S2CPacket> void sendToPlayer(ServerPlayer playerEntity, T packet) {
        SIMPLE_CHANNEL.sendTo(packet, playerEntity.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object objectToSend) {
        SIMPLE_CHANNEL.sendToServer(objectToSend);
    }

    public static <T extends S2CPacket> void handle(T packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> Client.clientHandle(packet));
            context.setPacketHandled(true);
        }
    }

    private static class Client {
        private Client() {
        }

        private static <T extends S2CPacket> void clientHandle(T packet) {
            packet.handle((Level)Minecraft.m_91087_().f_91073_);
        }
    }
}

